class UsersController < ApplicationController
  load_and_authorize_resource
  
  def index
    @users = collection
  end

  def show
    @user = User.new
  end

  def new
    @user = User.new
  end

  def create
    @user = User.find_or_create_by(user_params)
    @user.skip_password_validation = true
    @errorEmail = []
    @errorName  = []
    @errorContribution = []
    if params[:contributions_attributes][:contribution] < '1'
      @errorContribution.push('Amount must be greater than or equal 1 uah')
    end
    # @liqpay = Liqpay.new  
    if @user.save
      # Contribution.create(contribution: params[:contributions_attributes][:contribution], user_id: @user.id)
    else
      respond_to do |format|
        format.js
        @user.errors.any?
        if (@user.errors["email"] != nil)
          @errorEmail.push(@user.errors["email"][0])
        end
        if (@user.errors["name"] != nil)
          @errorName.push(@user.errors["name"][0])
        end
      end
    end
  end

  def edit
    @user = resource
  end

  def update
    @user = resource
    if @user.update(user_params)
      sign_in @user
      redirect_to user_path(user: @user)
    else
      render :edit
    end
  end

  def destroy
    @user = resource
    @user.destroy
  end

  def autocomplete_user
    @user = User.find_by(email: params[:email])
    if @user
      render status: 200, json: [@user, t('activerecord.errors.models.user.attributes.email.taken')]
    else
      render json: 0
    end
  end

  private

  def collection
    User.all
  end

  def resource
    User.find(params[:id])
  end

  def user_params
    params.require(:user).permit(:email, :name, :location, :picture, :avatar, :role, contributions_attributes: [:id, :user_id, :contribution])
  end

end