class Ckeditor::Asset < ActiveRecord::Base
  include Ckeditor::Orm::ActiveRecord::AssetBase

  delegate :url, :current_path, :content_type, to: :data

  validates :data, presence: true

  TYPES = %w( Picture )
  before_save :set_type

  def set_type
    raiser "You must override this method in each model inheriting from Product!"
  end
end
