class TranlasteProjects < ActiveRecord::Migration[5.0]
  def change
    reversible do |dir| # <=== 1
      dir.up do
        Project.create_translation_table!({ # <=== 2
                                         title: :string,
                                         individual_type: :string,
                                         heading: :string,
                                         short_description: :text,
                                         description: :text,
                                         related_links: :string
                                       }, {
                                         migrate_data: true, # <=== 4
                                         remove_source_columns: true # <=== 5
                                       })
      end
      dir.down do
        Project.drop_translation_table! migrate_data: true # <=== 6
      end
    end
  end
end
