Rails.application.routes.draw do
  scope "(:locale)", locale: /en|uk/ do
    mount Ckeditor::Engine => '/ckeditor'
	  root 'home#index'
    put "/admin/projects/:id", to: 'admin/projects#sort'    
	  ActiveAdmin.routes(self)
    resources :users
    resources :projects, only: [:show]
  end
  devise_for :users, controllers: {omniauth_callbacks: "users/omniauth_callbacks",
	  								  						registrations: "users"}
end
