class Ability
  include CanCan::Ability

  def initialize(user)
    user ||= User.new # guest user (not logged in)
    alias_action :create, :read, :update, :destroy, to: :crud

    if user.admin?
      can :read, ActiveAdmin::Page, :name => "Dashboard"
    end

    case
      when user.admin?
        #Dashboard
        can :index, :home
        # User related abilities
        can :manage, User
        can :manage, Project
        can :manage, ProjectPartial
      end
  end
end
