ActiveAdmin.register Project do

  menu label: 'Project'

  controller do
    
    def create
      @project = Project.new(project_params)
      if @project.save
        redirect_to admin_project_path(@project)
      else
        render :new
      end
    end

    def project_params
      params.require(:project).permit(:photo, :photo_preview, :photo_before, :photo_after, :types, 
                  :status, :individual_type_uk, :individual_type_en,
                  :title_uk, :title_en, :heading_uk, :heading_en, :slug, :short_description_uk,
                  :short_description_en, :description_uk,:description_en, :site,
                  :link_to_facebook, :required_amount, :related_links_uk, :related_links_en,
                  :footer_photo,
                  project_photos_attributes: [:id, :project_id, :photo, :title_uk,
                                              :title_en, :_destroy],
                  project_galeries_attributes: [:id, :project_id, :photo, :name_uk,
                                              :name_en, :_destroy],
                  project_qoutes_attributes: [:id, :project_id, :text_over_quote_uk, :text_over_quote_en,
                                              :background_color_quote_text, :icon, :text_quote_uk,
                                              :text_quote, :text_below_quote_uk, :text_below_quote, :_destroy],
                  project_links_attributes: [:id, :project_id, :site, :title_uk,
                                              :title_en, :_destroy],
                  project_documents_attributes: [:id, :project_id, :document_uk, :document_en,
                                              :document_name_uk, :document_name_en, :_destroy])
    end
  end
  
  form do |f|
    f.inputs do
      f.input :photo, label: "Photo"
      f.input :photo_preview, label: "Preview for main page"
      f.input :photo_before, label: "Before photo"
      f.input :photo_after, label: "After photo"
      f.input :types, label: "Type"
      f.input :status, label: "Status"
      f.input :individual_type_uk, label: "Individual type uk"
      f.input :individual_type_en, label: "Individual type en"
      f.input :title_uk, label: "Title uk"
      f.input :title_en, label: "Title en"
      f.input :slug, label: "Slug"
      f.input :heading_uk, label: "Heading uk"
      f.input :heading_en, label: "Heading en"
      f.input :short_description_uk, label: "Short description uk"
      f.input :short_description_en, label: "Short description en"
      f.input :description_uk, label: "Description uk"
      f.input :description_en, label: "Description en"
      f.input :site, label: "Site"
      f.input :link_to_facebook, label: "Link to Facebook"
      f.input :required_amount, label: "Required amount"
      f.input :related_links_uk, label: "Related links uk"
      f.input :related_links_en, label: "Related links en"
      f.input :footer_photo, label: "Footer photo"
      f.has_many :project_galeries, heading: false, new_record: true do |project_galaries_form|
        project_galaries_form.input :photo
        project_galaries_form.input :name_uk
        project_galaries_form.input :name_en
        project_galaries_form.input :_destroy, as: :boolean
      end
      f.has_many :project_qoutes, heading: false, new_record: true do |project_qoutes_form|
        project_qoutes_form.input :text_over_quote_uk
        project_qoutes_form.input :text_over_quote_en
        project_qoutes_form.input :background_color_quote_text, input_html: { class: 'colorpicker' }
        project_qoutes_form.input :icon
        project_qoutes_form.input :text_quote_uk
        project_qoutes_form.input :text_quote
        project_qoutes_form.input :text_below_quote_uk
        project_qoutes_form.input :text_below_quote
        project_qoutes_form.input :_destroy, as: :boolean
      end
      f.has_many :project_photos, heading: false, new_record: true do |project_photos_form|
        project_photos_form.input :photo
        project_photos_form.input :title_uk
        project_photos_form.input :title_en
        project_photos_form.input :_destroy, as: :boolean
      end
      f.has_many :project_links, heading: false, new_record: true do |project_links_form|
        project_links_form.input :site
        project_links_form.input :title_uk
        project_links_form.input :title_en
        project_links_form.input :_destroy, as: :boolean
      end
      f.has_many :project_documents, heading: false, new_record: true do |project_documents_form|
        project_documents_form.input :document_uk
        project_documents_form.input :document_en
        project_documents_form.input :document_name_uk
        project_documents_form.input :document_name_en
        project_documents_form.input :_destroy, as: :boolean
      end
    end
    f.actions
  end

end
