ActiveAdmin.register User do

  filter :email
  filter :name
  filter :location
  filter :created_at
  filter :updated_at
  filter :role

	permit_params :email, :role, :name, :location, :avatar

	index do
    selectable_column
    id_column
    column :email
    column :name
    column :location
    column :created_at
    column :updated_at
    column :role
    actions
	end


  show title: :name do
    panel "User Details" do
    	attributes_table_for user, :email, :name, :location, :created_at, 
    	                           :updated_at, :role 
	  end
  end

  form do |f|
    f.inputs do
      f.input :email
      f.input :name
      f.input :location
      f.input :password
      f.input :password_confirmation
      f.input :role
      f.input :avatar

    end
    f.actions
  end

end
