ActiveAdmin.register Project do

  menu label: 'Project'

  controller do
    
    def create
      @project = Project.new(project_params)
      if @project.save
        redirect_to admin_project_path(@project)
      else
        render :new
      end
    end

    def project_params
      params.require(:project).permit(:photo, :photo_preview, :photo_before, :remove_photo_before,
                  :photo_after, :remove_photo_after, :types, :status, :individual_type_uk, :individual_type_en,
                  :title_uk, :title_en, :heading_uk, :heading_en, :slug, :short_description_uk,
                  :short_description_en, :description_uk,:description_en, :site,
                  :link_to_facebook, :required_amount, :related_links_uk, :related_links_en,
                  :footer_photo, :remove_footer_photo,
                  project_photos_attributes: [:id, :project_id, :photo, :title_uk,
                                              :title_en, :_destroy],
                  project_galeries_attributes: [:id, :project_id, :photo, :name_uk,
                                              :name_en, :_destroy],
                  project_qoutes_attributes: [:id, :project_id, :text_over_quote_uk, :text_over_quote_en,
                                              :background_color_quote_text, :icon, :text_quote_uk,
                                              :text_quote, :text_below_quote_uk, :text_below_quote, :_destroy],
                  project_links_attributes: [:id, :project_id, :site, :title_uk,
                                              :title_en, :_destroy],
                  project_vidos_attributes: [:id, :project_id, :video_fiel, :video_link, :short_description_uk, 
                                              :short_description_en, :description_uk, :description_en, :_destroy],
                  project_documents_attributes: [:id, :project_id, :document_uk, :document_en,
                                              :document_name_uk, :document_name_en, :_destroy])
    end
  end
  
  form html: { multipart: true } do |f|
    f.inputs do
      f.input :photo, label: "Photo",
        hint: f.object.photo.present? ? image_tag(f.object.photo.url(:thumb_small)) : content_tag(:span, "no file yet")
      f.input :photo_preview, label: "Preview for main page", 
        hint: f.object.photo_preview.present? ? image_tag(f.object.photo_preview.url(:thumb_small)) : content_tag(:span, "no file yet")
      f.input :photo_before, label: "Before photo",
        hint: f.object.photo_before.present? ? image_tag(f.object.photo_before.url(:thumb_small)) : content_tag(:span, "no file yet")
      f.input :remove_photo_before, as: :boolean
      f.input :photo_after, label: "After photo",
        hint: f.object.photo_after.present? ? image_tag(f.object.photo_after.url(:thumb_small)) : content_tag(:span, "no file yet")        
      f.input :remove_photo_after, as: :boolean
      f.input :types, label: "Type"
      f.input :status, label: "Status"
      f.input :individual_type_uk, label: "Individual type uk"
      f.input :individual_type_en, label: "Individual type en"
      f.input :title_uk, label: "Title uk"
      f.input :title_en, label: "Title en"
      f.input :slug, label: "Slug"
      f.input :heading_uk, label: "Heading uk"
      f.input :heading_en, label: "Heading en"
      f.input :short_description_uk, label: "Short description uk"
      f.input :short_description_en, label: "Short description en"
      f.input :description_uk, label: "Description uk"
      f.input :description_en, label: "Description en"
      f.input :site, label: "Site"
      f.input :link_to_facebook, label: "Link to Facebook"
      f.input :required_amount, label: "Required amount"
      f.input :related_links_uk, label: "Related links uk"
      f.input :related_links_en, label: "Related links en"
      f.input :footer_photo, label: "Footer photo",
        hint: f.object.footer_photo.present? ? image_tag(f.object.footer_photo.url(:thumb_small)) : content_tag(:span, "no file yet")                
      f.input :remove_footer_photo, as: :boolean
      f.has_many :project_galeries, heading: false, new_record: true do |project_galaries_form|
        project_galaries_form.input :photo
        project_galaries_form.input :name_uk
        project_galaries_form.input :name_en
        project_galaries_form.input :_destroy, as: :boolean
      end
      f.has_many :project_qoutes, heading: false, new_record: true do |project_qoutes_form|
        project_qoutes_form.input :text_over_quote_uk
        project_qoutes_form.input :text_over_quote_en
        project_qoutes_form.input :background_color_quote_text, input_html: { class: 'colorpicker' }
        project_qoutes_form.input :icon
        project_qoutes_form.input :text_quote_uk
        project_qoutes_form.input :text_quote
        project_qoutes_form.input :text_below_quote_uk
        project_qoutes_form.input :text_below_quote
        project_qoutes_form.input :_destroy, as: :boolean
      end
      f.has_many :project_photos, heading: false, new_record: true do |project_photos_form|
        project_photos_form.input :photo
        project_photos_form.input :title_uk
        project_photos_form.input :title_en
        project_photos_form.input :_destroy, as: :boolean
      end
      f.has_many :project_links, heading: false, new_record: true do |project_links_form|
        project_links_form.input :site
        project_links_form.input :title_uk
        project_links_form.input :title_en
        project_links_form.input :_destroy, as: :boolean
      end
      f.has_many :project_documents, heading: false, new_record: true do |project_documents_form|
        project_documents_form.input :document_uk
        project_documents_form.input :document_en
        project_documents_form.input :document_name_uk
        project_documents_form.input :document_name_en
        project_documents_form.input :_destroy, as: :boolean
      end
      f.has_many :project_videos, heading: false, new_record: true do |project_videos_form|
        project_videos_form.input :short_description_uk
        project_videos_form.input :short_description_en
        project_videos_form.input :video_file
        project_videos_form.input :video_link
        project_videos_form.input :description_uk
        project_videos_form.input :description_en
        project_videos_form.input :_destroy, as: :boolean
      end
    end
    f.actions
  end

  index title: "Projects" do
    selectable_column
    id_column
    column "Photo" do |p|
      if p.photo?
        image_tag p.photo_url, height: '50'
      end
    end
    column "Type" do |p|
      p.types
    end
    column "Status" do |p|
      p.status
    end
    column "Individual type" do |p|
      p.individual_type_uk
    end
    column "Individual type en" do |p|
      p.individual_type_en
    end
    column "Title" do |p|
      p.title_uk
    end
    column "Title en" do |p|
      p.title_en
    end
    column "Site" do |p|
      p.site
    end
    column "Facebook link" do |p|
      p.link_to_facebook
    end
    column "Required amount" do |p|
      p.required_amount
    end
    column "Related links uk" do |p|
      p.related_links_uk
    end
    column "Related links en" do |p|
      p.related_links_en
    end
    column "Footer photo" do |p|
      p.footer_photo
    end
    column "Created" do |p|
      p.created_at
    end
    column "Updated" do |p|
      p.updated_at
    end
    actions
  end

  show do
    attributes_table  do
      row :id
      row I18n.t "active_admin.attributes.project.photo" do |p|
        p.photo? ? image_tag(p.photo_url(:thumb_small)) : image_tag("default_img.png")
      end
      row I18n.t "active_admin.attributes.project.photo_preview" do |p|
        p.photo_preview? ? image_tag(p.photo_preview_url(:thumb_small)) : image_tag("default_img.png")
      end
      row I18n.t "active_admin.attributes.project.photo_before" do |p|
        p.photo_before? ? image_tag(p.photo_before_url(:thumb_small)) : image_tag("default_img.png")
      end
      row I18n.t "active_admin.attributes.project.photo_after" do |p|
        p.photo_after? ? image_tag(p.photo_after_url(:thumb_small)) : image_tag("default_img.png")
      end
      row I18n.t "active_admin.attributes.project.types" do |p|
        t "#{p.types}"
      end
      row I18n.t "active_admin.attributes.project.status" do |p|
        t "#{p.status}"
      end
      row I18n.t "active_admin.attributes.project.individual_type_uk" do |p|
        p.individual_type_uk
      end
      row I18n.t "active_admin.attributes.project.individual_type_en" do |p|
        p.individual_type_en
      end
      row I18n.t "active_admin.attributes.project.title_uk" do |p|
      p.title_uk
      end
      row I18n.t "active_admin.attributes.project.title_en" do |p|
        p.title_en
      end
      row I18n.t "active_admin.attributes.project.site" do |p|
        p.site
      end
      row I18n.t "active_admin.attributes.project.link_to_facebook" do |p|
        p.link_to_facebook
      end
      row I18n.t "active_admin.attributes.project.required_amount" do |p|
        p.required_amount
      end
      row I18n.t "active_admin.attributes.project.related_links_uk" do |p|
        p.related_links_uk
      end
      row I18n.t "active_admin.attributes.project.related_links_en" do |p|
        p.related_links_en
      end
      row I18n.t "active_admin.attributes.project.footer_photo" do |p|
        p.footer_photo? ? image_tag(p.footer_photo_url(:thumb_small)) : image_tag("default_img.png")
      end
      row I18n.t "active_admin.attributes.project.created_at" do |p|
        p.created_at
      end
      row I18n.t "active_admin.attributes.project.updated_at" do |p|
        p.updated_at
      end
    end
  end

end
