ActiveAdmin.register User do
  menu label: proc{ I18n.t "active_admin.models.user.other" }

  filter :email, label: I18n.t("active_admin.attributes.user.email")
  filter :name, label: I18n.t("active_admin.attributes.user.name")
  filter :location, label: I18n.t("active_admin.attributes.user.location")
  filter :created_at, label: I18n.t("active_admin.attributes.user.created_at")
  filter :updated_at, label: I18n.t("active_admin.attributes.user.updated_at")
  filter :role, label: I18n.t("active_admin.attributes.user.role")

	permit_params :email, :role, :name, :location, :avatar, :password, :password_confirmation, :role

  index title: proc{ I18n.t "active_admin.models.user.other" } do
    selectable_column
    id_column
    column I18n.t "active_admin.attributes.user.avatar" do |u|
      if u.avatar?
        image_tag u.avatar_url, height: '50'
      end
    end
    column I18n.t "active_admin.attributes.user.name" do |u|
      u.name
    end
    column I18n.t "active_admin.attributes.user.email" do |u|
      u.email
    end
    column I18n.t "active_admin.attributes.user.location" do |u|
      u.location
    end
    column I18n.t "active_admin.attributes.user.created_at" do |u|
      u.created_at
    end
    column I18n.t "active_admin.attributes.user.updated_at" do |u|
      u.updated_at
    end
    column I18n.t "active_admin.attributes.user.role" do |u|
      (t "active_admin.attributes.user/role.#{u.role}")
    end
    actions
  end

  show do
    attributes_table  do
      row :id
      row I18n.t "active_admin.attributes.user.name" do |u|
        u.name
      end
      row I18n.t "active_admin.attributes.user.email" do |u|
        u.email
      end
      row I18n.t "active_admin.attributes.user.location" do |u|
        u.location
      end
      row I18n.t "active_admin.attributes.user.role" do |u|
        (t "active_admin.attributes.user/role.#{u.role}")
      end
      row I18n.t "active_admin.attributes.user.created_at" do |u|
        u.created_at
      end
      row I18n.t "active_admin.attributes.user.updated_at" do |u|
        u.updated_at
      end
    end
  end


  form do |f|
    f.inputs do
      f.input :email, label: "#{t "active_admin.attributes.user.email"}"
      f.input :name, label: "#{t "active_admin.attributes.user.name"}"
      f.input :location, label: "#{t "active_admin.attributes.user.location"}"
      f.input :password, label: "#{t "active_admin.attributes.user.password"}"
      f.input :password_confirmation, label: "#{t "active_admin.attributes.user.password_confirmation"}"
      f.input :role, as: :select, collection: User.roles.map { |role| [I18n.t("active_admin.user/role.#{role[0]}"), role[0]] }, 
              label: (t "active_admin.attributes.user.role")
      f.input :avatar, label: "#{t "active_admin.attributes.user.avatar"}"
    end
    f.actions
  end

end
