class Project < ApplicationRecord
	mount_uploader :photo, AvatarUploader
	mount_uploader :photo_preview, AvatarUploader
	mount_uploader :photo_before, AvatarUploader
    mount_uploader :photo_after, AvatarUploader
    mount_uploader :footer_photo, AvatarUploader

    enum types: [:program, :project]
	enum status: [:in_progress, :implemented]

	has_many :project_galeries, inverse_of: :project, dependent: :destroy
	has_many :project_qoutes, inverse_of: :project, dependent: :destroy
	has_many :project_photos, inverse_of: :project, dependent: :destroy
	has_many :project_links, inverse_of: :project, dependent: :destroy
	has_many :project_documents, inverse_of: :project, dependent: :destroy
	has_many :project_videos, inverse_of: :project, dependent: :destroy
	accepts_nested_attributes_for :project_galeries, reject_if: :all_blank, allow_destroy: true
	accepts_nested_attributes_for :project_qoutes, reject_if: :all_blank, allow_destroy: true
	accepts_nested_attributes_for :project_photos, reject_if: :all_blank, allow_destroy: true
	accepts_nested_attributes_for :project_links, reject_if: :all_blank, allow_destroy: true
	accepts_nested_attributes_for :project_documents, reject_if: :all_blank, allow_destroy: true
	accepts_nested_attributes_for :project_videos, reject_if: :all_blank, allow_destroy: true

	validates :photo, :photo_preview, :types, :status, :title_uk, :short_description_uk,
	:description_uk, :required_amount, presence: true
	validates_length_of :individual_type_uk, :individual_type_en, :title_uk, :title_en,
	:heading_uk, :heading_en, :site, :link_to_facebook, :related_links_uk,
	:related_links_en, maximum: 200
	validates_length_of :short_description_uk, :short_description_en, maximum: 2000
	validates_length_of :description_uk, :description_en, maximum: 5000

	
end
