Rails.application.routes.draw do
  scope "(:locale)", locale: /en|uk/ do
    mount Ckeditor::Engine => '/ckeditor'
	root 'home#index'
	ActiveAdmin.routes(self)
    resources :users
    resources :projects, only: [:show]
    resources :project_partials do 
      collection do 
      	patch :sort
      end
    end
  end
  devise_for :users, controllers: {omniauth_callbacks: "users/omniauth_callbacks",
	  								  						registrations: "users"}
end
