class TranslateProjectDocuments < ActiveRecord::Migration[5.0]
  def change
    reversible do |dir| # <=== 1
      dir.up do
        ProjectDocument.create_translation_table!({ # <=== 2
                                         document_name: :string
                                       }, {
                                         migrate_data: true, # <=== 4
                                         remove_source_columns: true # <=== 5
                                       })
      end
      dir.down do
        ProjectDocument.drop_translation_table! migrate_data: true # <=== 6
      end
    end
  end
end
