class UsersController < ApplicationController

  def index
    @users = collection
  end

  def show
    @user = resource
  end

  def new
    @user = User.new
  end

  def create
    @user = User.find_or_create_by(user_params)
    @user.skip_password_validation = true
    if @user.save
      redirect_to root_path
    else
      redirect_to root_path
    end
  end

  def edit
    @user = resource
  end

  def update
    @user = resource
    if @user.update(user_params)
      redirect_to user_path(user: @user)
    else
      render :edit
    end
  end

  def destroy
    @user = resource
    @user.destroy

    redirect_to users_path
  end

  private

  def collection
    User.all
  end

  def resource
    User.find(params[:id])
  end

  def user_params
    params.require(:user).permit(:email, :name, :location)
  end

end