Rails.application.routes.draw do
  scope "(:locale)", locale: /en|uk/ do
    mount Ckeditor::Engine => '/ckeditor'
	  root 'home#index'
    get "/autocomplete_user", to: "users#autocomplete_user"
    put "/admin/projects/:id", to: 'admin/projects#sort'    
	  ActiveAdmin.routes(self)
    resources :users
    resources :projects, only: [:show]
    resources :payments do
      collection do
        post :liqpay_payment, to: "payments#liqpay_payment", as: :liqpay_payment
        post :interkassa_success, to: "payments#interkassa_success", as: :interkassa_success
        post :interkassa_fail, to: "payments#interkassa_fail", as: :interkassa_fail
        post :interkassa_pending, to: "payments#interkassa_pending", as: :interkassa_pending
        post :interkassa_interaction, to: "payments#interkassa_interaction", as: :interkassa_interaction
      end  
    end  
  end
  devise_for :users, controllers: {omniauth_callbacks: "users/omniauth_callbacks",
	  								  						registrations: "users"}
end
