class CreatePayments < ActiveRecord::Migration[5.0]
  def change
    create_table   :payments do |t|
      t.string     :action
      t.integer    :payment_id
      t.string     :status
      t.integer    :version
      t.string     :type_of_payment
      t.string     :paytype
      t.string     :public_key
      t.integer    :acq_id
      t.string     :order_id
      t.string     :liqpay_order_id
      t.string     :description
      t.string     :sender_phone
      t.string     :sender_card_mask2
      t.string     :sender_card_bank
      t.string     :sender_card_type
      t.integer    :sender_card_country
      t.string     :ip
      t.float      :amount
      t.string     :currency
      t.float      :sender_commission
      t.float      :receiver_commission
      t.float      :agent_commission
      t.float      :amount_debit
      t.float      :amount_credit
      t.float      :commission_debit
      t.float      :commission_credit
      t.string     :currency_debit
      t.string     :currency_credit
      t.float      :sender_bonus
      t.float      :amount_bonus
      t.string     :mpi_eci
      t.boolean    :is_3ds
      t.string     :language
      t.bigint     :create_date
      t.bigint     :end_date
      t.integer    :transaction_id
      t.string     :ik_co_id
      t.bigint     :ik_co_prs_id
      t.string     :ik_pm_no
      t.float      :ik_am
      t.float      :ik_ps_price
      t.string     :ik_sign
      t.references :user
      t.references :project      
      t.timestamps
    end
  end
end
