ActiveAdmin.register Payment do

  menu label: proc{ I18n.t "active_admin.models.payment" }

  permit_params :sender_card_country

  index title: proc{ I18n.t "active_admin.models.payment" } do
    selectable_column
    id_column
    column "User" do |p|
      p.user
    end
    column "Email" do |p|
      p.user.email
    end
    column "Project" do |p|
      p.project
    end
    column "Amount" do |p|
      p.amount
    end
    column "Description" do |p|
      p.description
    end
    column "Status" do |p|
      status_tag "#{p.status}", class: 'important'
    end
    column "Created" do |p|
      p.created_at
    end
    column "Updated" do |p|
      p.updated_at
    end
    actions
  end

  show do
    attributes_table  do
      row :id
      row "Project" do |p|
        p.project
      end
      row "User" do |p|
        p.user.name
      end
      row "Email" do |p|
        p.user.email
      end
      row "Project" do |p|
        p.project
      end
      row "Action" do |p|
        p.action
      end
      row "Phone" do |p|
        p.sender_phone
      end
      row "Pay type" do |p|
        p.paytype
      end
      row "Amount" do |p|
        p.amount
      end
      row "Description" do |p|
        p.description
      end
      row "Currency" do |p|
        p.currency
      end
      row "Country code" do |p|
        p.sender_card_country
      end
      row "Payment id" do |p|
        p.payment_id
      end
      row "Status" do |p|
        status_tag "#{p.status}"
      end
      row "API version" do |p|
        p.version
      end
      row "Create date" do |p|
        p.create_date
      end
      row "End date" do |p|
        p.end_date
      end
      row "Transaction id" do |p|
        p.transaction_id
      end
      row "Created" do |p|
        p.created_at
      end
      row "Updated" do |p|
        p.updated_at
      end
    end
  end

  form do |f|
    f.inputs do
      f.input :project
      f.input :user
      f.input :sender_phone
      f.input :amount
      f.input :description
      f.input :currency
      f.input :sender_card_country, as: :country
    end
    f.actions
  end

end
