class PaymentsController < ApplicationController
  protect_from_forgery :except => :liqpay_payment
  skip_before_action :verify_authenticity_token

  def liqpay_payment
  	data      = request.parameters['data']
    signature = request.parameters['signature']
    liqpay = Liqpay.new
    if liqpay.match?(data, signature)
      responce_hash = liqpay.decode_data(data)
      responce_hash["type_of_payment"] = responce_hash.delete("type")
      responce_hash["project_id"] = responce_hash["order_id"].split("_")[0]
      responce_hash["user_id"] = current_user.id
      if responce_hash['status'] == "success"
        Payment.create(responce_hash)
      end
    end
    redirect_to root_path
  end

end
