Rails.application.routes.draw do
  scope "(:locale)", locale: /en|uk/ do
    mount Ckeditor::Engine => '/ckeditor'
	  root 'home#index'
    
    get "/autocomplete_user", to: "users#autocomplete_user"
    put "/admin/projects/:id", to: 'admin/projects#sort'    
	  ActiveAdmin.routes(self)
    resources :users
    resources :projects, only: [:show]
    resources :payments do
      collection do
        post :liqpay_payment, to: "payments#liqpay_payment", as: :liqpay_payment
      end  
    end  
  end
  devise_for :users, controllers: {omniauth_callbacks: "users/omniauth_callbacks",
	  								  						registrations: "users"}
end
