class ProjectsController < ApplicationController
  load_and_authorize_resource
  
  def index
    @projects = collection
  end

  def show
    @project = Project.new
  end

  def new
    @project = Project.new
  end

  def create
    @project = Project.create(project_params)
    if @project.save
      redirect_to projects_path
    else
      render :new
    end
  end

  def edit
    @project = resource
  end

  def update
    @project = resource
    if @project.update(project_params)
      redirect_to project_path(project: @project)
    else
      render :edit
    end
  end

  def destroy
    @project = resource
    @project.destroy
    redirect_to projects_path
  end

  private

  def collection
    Project.all
  end

  def resource
    Project.find(params[:id])
  end

  def user_params
    params.require(:project).permit(:photo, :photo_preview, :photo_before, :photo_after, :type, 
                                    :status, :name, :name_eng, :individual_type_ua, :individual_type_en,
                                    :title_ua, :title_en, :heading_ua, :heading_en, :slug, :short_description_ua,
                                    :short_description_en, :description_ua,:description_en, :site,
                                    :link_to_facebook, :required_amount, :related_links_ua, :related_links_en,
                                    :footer_photo)
  end

end