class Project < ApplicationRecord
	has_many :project_galeries, dependent: :destroy
	accepts_nested_attributes_for :project_galeries, reject_if: :all_blank, allow_destroy: true

	mount_uploader :photo, AvatarUploader
	mount_uploader {:photo_preview, :photo_before}, AvatarUploader

	validates :status, :name, :short_description_ua,
	:description_ua, :required_amount, presence: true

	enum type: [:program, :project]
	enum status: [:in_progress, :implemented]
end
