class UsersController < ApplicationController
  load_and_authorize_resource
  
  def index
    @users = collection
  end

  def show
    @user = User.new
  end

  def new
    @user = User.new
  end

  def create
    @user = User.find_or_create_by(user_params)
    @user.skip_password_validation = true
    respond_to do |format|
      if @user.save 
        format.html { redirect_to root_path }
        format.js
      else
        format.html
        format.js
      end
    end
  end

  def edit
    @user = resource
  end

  def update
    @user = resource
    if @user.update(user_params)
      sign_in @user
      redirect_to user_path(user: @user)
    else
      render :edit
    end
  end

  def destroy
    @user = resource
    @user.destroy
  end

  def autocomplete_user
    @user = User.find_by(email: params[:email])
    if @user
      render status: 200, json: [@user, t('activerecord.errors.models.user.attributes.email.taken')]
    else
      render json: 0
    end
  end

  private

  def collection
    User.all
  end

  def resource
    User.find(params[:id])
  end

  def user_params
    params.require(:user).permit(:email, :name, :location, :picture, :avatar, :role)
  end

end