class UsersController < ApplicationController

  def index
    @users = collection
  end

  def show
    @user = resource
  end

  def new
    @user = User.new
  end

  def create
    @user = User.find_or_create_by(user_params)
    @user.skip_password_validation = true
    if @user.save
      redirect_to edit_user_path(@user)
    elsif
      redirect_to root_path
    end
  end

  def edit
    @user = resource
  end

  def update
    @user = resource
    @user.skip_password_validation = false
    if @user.update(user_params)
      sign_in @user
      redirect_to user_path(@user)
    else
      puts @user.errors.messages
      render :edit
    end
  end

  def destroy
    @user = resource
    @user.destroy

    redirect_to users_path
  end

  private

  def collection
    User.all
  end

  def resource
    User.find(params[:id])
  end

  def user_params
    params.require(:user).permit(:email, :name, :location, 
                                 :password, :password_confirmation)
  end

end