ActiveAdmin.register Project do

  menu label: proc{ I18n.t "active_admin.models.project.other" }

  filter :photo, label: I18n.t("active_admin.attributes.project.photo")
  filter :types, label: I18n.t("active_admin.attributes.project.types")
  filter :status, label: I18n.t("active_admin.attributes.project.status")
  filter :individual_type_uk, label: I18n.t("active_admin.attributes.project.individual_type_uk")
  filter :individual_type_en, label: I18n.t("active_admin.attributes.project.individual_type_en")
  filter :title_uk, label: I18n.t("active_admin.attributes.project.title_uk")
  filter :title_en, label: I18n.t("active_admin.attributes.project.title_en")
  filter :site, label: I18n.t("active_admin.attributes.project.site")
  filter :link_to_facebook, label: I18n.t("active_admin.attributes.project.link_to_facebook")
  filter :required_amount, label: I18n.t("active_admin.attributes.project.required_amount")
  filter :related_links_uk, label: I18n.t("active_admin.attributes.project.related_links_uk")
  filter :related_links_en, label: I18n.t("active_admin.attributes.project.related_links_en")
  filter :created_at, label: I18n.t("active_admin.attributes.project.created_at")
  filter :updated_at, label: I18n.t("active_admin.attributes.project.updated_at")

  controller do

    def create
      @project = Project.new(project_params)
      if @project.save
        ProjectPartialsService.new(@project).set_project_partials
        redirect_to admin_project_path(@project)
      else
        render :new
      end
    end

    def show
      @project = find_resource
    end

    def find_resource
      scoped_collection.friendly.find(params[:id])
    end

    def sort
      params[:project_partial].each_with_index do |id, index|
        ProjectPartial.find(id).update_column(:position, index + 1)
      end

      head :ok
    end

    def project_params
      params.require(:project).permit(:position, :photo, :photo_preview, :photo_before, :remove_photo_before,
                  :photo_after, :remove_photo_after, :types, :status, :individual_type_uk, :individual_type_en,
                  :title_uk, :title_en, :heading_uk, :heading_en, :slug, :short_description_uk,
                  :short_description_en, :description_uk,:description_en, :site,
                  :link_to_facebook, :required_amount, :related_links_uk, :related_links_en,
                  :footer_photo, :remove_footer_photo, :aasm_state,
                  project_photos_attributes: [:id, :project_id, :photo, :title_uk,
                                              :title_en, :_destroy],
                  project_galeries_attributes: [:id, :project_id, :photo, :name_uk,
                                              :name_en, :_destroy],
                  project_qoutes_attributes: [:id, :project_id, :text_over_quote_uk, :text_over_quote_en,
                                              :background_color_quote_text, :icon, :text_quote_uk,
                                              :text_quote, :text_below_quote_uk, :text_below_quote, :_destroy],
                  project_links_attributes: [:id, :project_id, :site, :title_uk,
                                              :title_en, :_destroy],
                  project_videos_attributes: [:id, :project_id, :video_file, :video_link, :short_description_uk, 
                                              :short_description_en, :description_uk, :description_en, :_destroy],
                  project_documents_attributes: [:id, :project_id, :document_uk, :document_en,
                                              :document_name_uk, :document_name_en, :_destroy])
    end

  end
  
  form html: { multipart: true } do |f|
    f.inputs do
      f.input :aasm_state,  as: :select, collection: [:approved, :show], label: 'State'
      f.input :photo, label: "#{t "active_admin.attributes.project.photo"}",
        hint: f.object.photo.present? ? image_tag(f.object.photo.url(:thumb_small)) : content_tag(:span, "no file yet")
      f.input :photo_preview, label: "#{t "active_admin.attributes.project.photo_preview"}", 
        hint: f.object.photo_preview.present? ? image_tag(f.object.photo_preview.url(:thumb_small)) : content_tag(:span, "no file yet")
      f.input :photo_before, label: "#{t "active_admin.attributes.project.photo_before"}",
        hint: f.object.photo_before.present? ? image_tag(f.object.photo_before.url(:thumb_small)) : content_tag(:span, "no file yet")
      f.input :remove_photo_before, as: :boolean, label: "#{t "active_admin.attributes.project.remove_photo"}"
      f.input :photo_after, label: "#{t "active_admin.attributes.project.photo_after"}",
        hint: f.object.photo_after.present? ? image_tag(f.object.photo_after.url(:thumb_small)) : content_tag(:span, "no file yet")        
      f.input :remove_photo_after, as: :boolean, label: "#{t "active_admin.attributes.project.remove_photo"}"
      f.input :types,  as: :select, collection: Project.types.map { |type| [I18n.t("active_admin.project/types.#{type[0]}"), type[0]] },
        label: "#{t "active_admin.attributes.project.types"}"
      f.input :status, as: :select, collection: Project.statuses.map { |status| [I18n.t("active_admin.project/status.#{status[0]}"), status[0]] },
        label: "#{t "active_admin.attributes.project.status"}"
      f.input :individual_type_uk, label: "#{t "active_admin.attributes.project.individual_type_uk"}"
      f.input :individual_type_en, label: "#{t "active_admin.attributes.project.individual_type_en"}"
      f.input :title_uk, label: "#{t "active_admin.attributes.project.title_uk"}"
      f.input :title_en, label: "#{t "active_admin.attributes.project.title_en"}"
      f.input :slug, label: "#{t "active_admin.attributes.project.slug"}"
      f.input :heading_uk, label: "#{t "active_admin.attributes.project.heading_uk"}"
      f.input :heading_en, label: "#{t "active_admin.attributes.project.heading_en"}"
      f.input :short_description_uk, as: :ckeditor, input_html: { ckeditor: { height: 400 } }, label: "#{t "active_admin.attributes.project.short_description_uk"}"
      f.input :short_description_en, as: :ckeditor, input_html: { ckeditor: { height: 400 } }, label: "#{t "active_admin.attributes.project.short_description_en"}"
      f.input :description_uk, as: :ckeditor, input_html: { ckeditor: { height: 400 } }, label: "#{t "active_admin.attributes.project.description_uk"}"
      f.input :description_en, as: :ckeditor, input_html: { ckeditor: { height: 400 } }, label: "#{t "active_admin.attributes.project.description_en"}"
      f.input :site, label: "#{t "active_admin.attributes.project.site"}"
      f.input :link_to_facebook, label: "#{t "active_admin.attributes.project.link_to_facebook"}"
      f.input :required_amount, label: "#{t "active_admin.attributes.project.required_amount"}"
      f.input :related_links_uk, label: "#{t "active_admin.attributes.project.related_links_uk"}"
      f.input :related_links_en, label: "#{t "active_admin.attributes.project.related_links_en"}"
      f.input :footer_photo, label: "#{t "active_admin.attributes.project.footer_photo"}",
        hint: f.object.footer_photo.present? ? image_tag(f.object.footer_photo.url(:thumb_small)) : content_tag(:span, "no file yet")                
      f.input :remove_footer_photo, as: :boolean, label: "#{t "active_admin.attributes.project.remove_photo"}"
      f.has_many :project_galeries, heading: false, new_record: true do |project_galaries_form|
        project_galaries_form.input :photo, label: "#{t "active_admin.attributes.project_galeries.photo"}"
        project_galaries_form.input :name_uk, label: "#{t "active_admin.attributes.project_galeries.name_uk"}"
        project_galaries_form.input :name_en, label: "#{t "active_admin.attributes.project_galeries.name_en"}"
        project_galaries_form.input :_destroy, as: :boolean, label: "#{t "active_admin.attributes.project._destroy"}"
      end
      f.has_many :project_qoutes, heading: false, new_record: true do |project_qoutes_form|
        project_qoutes_form.input :text_over_quote_uk, as: :ckeditor, input_html: { ckeditor: { height: 400 } }, label: "#{t "active_admin.attributes.project_qoutes.text_over_quote_uk"}"
        project_qoutes_form.input :text_over_quote_en, as: :ckeditor, input_html: { ckeditor: { height: 400 } }, label: "#{t "active_admin.attributes.project_qoutes.text_over_quote_en"}"
        project_qoutes_form.input :background_color_quote_text, input_html: { class: 'colorpicker' }, label: "#{t "active_admin.attributes.project_qoutes.background_color_quote_text"}"
        project_qoutes_form.input :icon, label: "#{t "active_admin.attributes.project_qoutes.icon"}"
        project_qoutes_form.input :text_quote_uk, as: :ckeditor, input_html: { ckeditor: { height: 400 } }, label: "#{t "active_admin.attributes.project_qoutes.text_quote_uk"}"
        project_qoutes_form.input :text_quote, as: :ckeditor, input_html: { ckeditor: { height: 400 } }, label: "#{t "active_admin.attributes.project_qoutes.text_quote"}"
        project_qoutes_form.input :text_below_quote_uk, as: :ckeditor, input_html: { ckeditor: { height: 400 } }, label: "#{t "active_admin.attributes.project_qoutes.text_below_quote_uk"}"
        project_qoutes_form.input :text_below_quote, as: :ckeditor, input_html: { ckeditor: { height: 400 } }, label: "#{t "active_admin.attributes.project_qoutes.text_below_quote"}"
        project_qoutes_form.input :_destroy, as: :boolean, label: "#{t "active_admin.attributes.project._destroy"}"
      end
      f.has_many :project_photos, heading: false, new_record: true do |project_photos_form|
        project_photos_form.input :photo, label: "#{t "active_admin.attributes.project_photos.photo"}"
        project_photos_form.input :title_uk, label: "#{t "active_admin.attributes.project_photos.title_uk"}"
        project_photos_form.input :title_en, label: "#{t "active_admin.attributes.project_photos.title_en"}"
        project_photos_form.input :_destroy, as: :boolean, label: "#{t "active_admin.attributes.project._destroy"}"
      end
      f.has_many :project_links, heading: false, new_record: true do |project_links_form|
        project_links_form.input :site, label: "#{t "active_admin.attributes.project_links.site"}"
        project_links_form.input :title_uk, label: "#{t "active_admin.attributes.project_links.title_uk"}"
        project_links_form.input :title_en, label: "#{t "active_admin.attributes.project_links.title_en"}"
        project_links_form.input :_destroy, as: :boolean, label: "#{t "active_admin.attributes.project._destroy"}"
      end
      f.has_many :project_documents, heading: false, new_record: true do |project_documents_form|
        project_documents_form.input :document_uk, label: "#{t "active_admin.attributes.project_documents.document_uk"}"
        project_documents_form.input :document_en, label: "#{t "active_admin.attributes.project_documents.document_en"}"
        project_documents_form.input :document_name_uk, label: "#{t "active_admin.attributes.project_documents.document_name_uk"}"
        project_documents_form.input :document_name_en, label: "#{t "active_admin.attributes.project_documents.document_name_en"}"
        project_documents_form.input :_destroy, as: :boolean, label: "#{t "active_admin.attributes.project._destroy"}"
      end
      f.has_many :project_videos, heading: false, new_record: true do |project_videos_form|
        project_videos_form.input :short_uk, as: :ckeditor, input_html: { ckeditor: { height: 400 } }, label: "#{t "active_admin.attributes.project_videos.short_description_uk"}"
        project_videos_form.input :short_en, as: :ckeditor, input_html: { ckeditor: { height: 400 } }, label: "#{t "active_admin.attributes.project_videos.short_description_en"}"
        project_videos_form.input :video_file, label: "#{t "active_admin.attributes.project_videos.video_file"}"
        project_videos_form.input :video_link, label: "#{t "active_admin.attributes.project_videos.video_link"}"
        project_videos_form.input :description_uk, as: :ckeditor, input_html: { ckeditor: { height: 400 } }, label: "#{t "active_admin.attributes.project_videos.description_uk"}"
        project_videos_form.input :description_en, as: :ckeditor, input_html: { ckeditor: { height: 400 } }, label: "#{t "active_admin.attributes.project_videos.description_en"}"
        project_videos_form.input :_destroy, as: :boolean, label: "#{t "active_admin.attributes.project._destroy"}"
      end
    end
    f.actions
  end

  index title: "Projects" do
    selectable_column
    id_column
    column "Photo" do |p|
      if p.photo?
        image_tag p.photo_url, height: '50'
      end
    end
    column I18n.t "active_admin.attributes.project.types" do |p|
      t "#{p.types}"
    end
    column I18n.t "active_admin.attributes.project.status" do |p|
      t "#{p.status}"
    end
    column I18n.t "active_admin.attributes.project.individual_type_uk" do |p|
      p.individual_type_uk
    end
    column I18n.t "active_admin.attributes.project.individual_type_en" do |p|
      p.individual_type_en
    end
    column I18n.t "active_admin.attributes.project.title_uk" do |p|
      p.title_uk
    end
    column I18n.t "active_admin.attributes.project.title_en" do |p|
      p.title_en
    end
    column I18n.t "active_admin.attributes.project.site" do |p|
      p.site
    end
    column I18n.t "active_admin.attributes.project.link_to_facebook" do |p|
      p.link_to_facebook
    end
    column I18n.t "active_admin.attributes.project.required_amount" do |p|
      p.required_amount
    end
    column I18n.t "active_admin.attributes.project.related_links_uk" do |p|
      p.related_links_uk
    end
    column I18n.t "active_admin.attributes.project.related_links_en" do |p|
      p.related_links_en
    end
    column I18n.t "active_admin.attributes.project.footer_photo" do |p|
      p.footer_photo
    end
    column I18n.t "active_admin.attributes.project.created_at" do |p|
      p.created_at
    end
    column I18n.t "active_admin.attributes.project.updated_at" do |p|
      p.updated_at
    end
    actions
  end

  show do
    attributes_table  do
      row :id
      row "State" do |p|
        p.aasm_state
      end
      row I18n.t "active_admin.attributes.project.photo" do |p|
        p.photo? ? image_tag(p.photo_url(:thumb_small)) : image_tag("default_img.png")
      end
      row I18n.t "active_admin.attributes.project.photo_preview" do |p|
        p.photo_preview? ? image_tag(p.photo_preview_url(:thumb_small)) : image_tag("default_img.png")
      end
      row I18n.t "active_admin.attributes.project.photo_before" do |p|
        p.photo_before? ? image_tag(p.photo_before_url(:thumb_small)) : image_tag("default_img.png")
      end
      row I18n.t "active_admin.attributes.project.photo_after" do |p|
        p.photo_after? ? image_tag(p.photo_after_url(:thumb_small)) : image_tag("default_img.png")
      end
      row I18n.t "active_admin.attributes.project.types" do |p|
        t "#{p.types}"
      end
      row I18n.t "active_admin.attributes.project.status" do |p|
        t "#{p.status}"
      end
      row I18n.t "active_admin.attributes.project.individual_type_uk" do |p|
        p.individual_type_uk
      end
      row I18n.t "active_admin.attributes.project.individual_type_en" do |p|
        p.individual_type_en
      end
      row I18n.t "active_admin.attributes.project.title_uk" do |p|
      p.title_uk
      end
      row I18n.t "active_admin.attributes.project.title_en" do |p|
        p.title_en
      end
      row I18n.t "active_admin.attributes.project.slug" do |p|
        p.slug
      end
      row I18n.t "active_admin.attributes.project.site" do |p|
        p.site
      end
      row I18n.t "active_admin.attributes.project.link_to_facebook" do |p|
        p.link_to_facebook
      end
      row I18n.t "active_admin.attributes.project.required_amount" do |p|
        p.required_amount
      end
      row I18n.t "active_admin.attributes.project.related_links_uk" do |p|
        p.related_links_uk
      end
      row I18n.t "active_admin.attributes.project.related_links_en" do |p|
        p.related_links_en
      end
      row I18n.t "active_admin.attributes.project.footer_photo" do |p|
        p.footer_photo? ? image_tag(p.footer_photo_url(:thumb_small)) : image_tag("default_img.png")
      end
      row I18n.t "active_admin.attributes.project.created_at" do |p|
        p.created_at
      end
      row I18n.t "active_admin.attributes.project.updated_at" do |p|
        p.updated_at
      end
    end
  end

  sidebar "Project Partials", only: :show do
    table_for project.project_partials.order(:position) do 
      column :title
    end
  end
end
