class User < ApplicationRecord
  attr_accessor :skip_password_validation

  after_initialize :set_default_role, :if => :new_record?

  after_create :send_email_to_user

  mount_uploader :avatar, AvatarUploader
  
  has_many :payments, dependent: :destroy
  
  enum role: [:user, :admin]

  validates :name, presence: true

  def set_default_role
    self.role ||= :user
  end
  
  devise :database_authenticatable, :registerable,
         :recoverable, :rememberable, :validatable, :omniauthable, 
         omniauth_providers: [:facebook, :google_oauth2, :linkedin]

  def self.new_with_session(params, session)
    super.tap do |user|
      if data = session["devise.facebook_data"] && session["devise.facebook_data"]["extra"]["raw_info"]
        user.email = data["email"] if user.email.blank?
      end
    end
  end

  def self.from_omniauth(access_token)
    data = access_token.info
    user = User.where(email: data['email']).first

    # Uncomment the section below if you want users to be created if they don't exist
    unless user
        user = User.create(name: data['name'],
           email: data['email'],
           password: Devise.friendly_token[0,20]
        )
    end
    user
  end

  protected

  def send_email_to_user
    gibbon = Gibbon::Request.new(api_key: "e5f9a6a9edc148b49496c1b972f673b7-us4")
    gibbon.lists('938061d57b').members.create(body: {email_address: self.email, status: "subscribed", 
                                              merge_fields: {MMERGE1: self.name}})
  end

  def password_required?
    return false if skip_password_validation
    super
  end

end
