class ApplicationController < ActionController::Base
  protect_from_forgery with: :exception

  def set_locale
    I18n.locale = params[:locale] || I18n.default_locale
  end

  def default_url_options
    { locale: I18n.locale }
  end

  def authenticate_user!
    redirect_to root_path, notice: 'Для подальшої роботи з системою Вам потрібно авторизуватися' unless user_signed_in?
  end
end
