<?php

namespace App\Http\Controllers;


use App\Http\Controllers\Traits\HandlesDataTableRequest;
use App\Http\Resources\TodoItemTableResource;
use App\Repositories\TodoItemRepository;
use Illuminate\Http\Request;

/**
 * Class TodoItemTableController
 * @package App\Http\Controllers
 */
class TodoItemTableController extends Controller
{
    use HandlesDataTableRequest;

    const COLUMN_MAPPINGS = [
        'created_at',
        'title',
        'description',
        'created_at',
        'id'
    ];

    /**
     * Display a listing of the resource.
     *
     * @param Request $request
     * @return array
     */
    public function index(Request $request): array
    {
        /** @var TodoItemRepository $todoItemRepository */
        $todoItemRepository = app(TodoItemRepository::class);

        [$search, $offset, $length, $orderColumn, $orderDirection] = $this->getRequestData($request);
        $totalTodoItems = $todoItemRepository->count();
        $todoItems = $todoItemRepository->filter($search, $offset, $length, $orderColumn, $orderDirection);

        return [
            'data' => TodoItemTableResource::collection($todoItems),
            'recordsTotal' => $totalTodoItems,
            'recordsFiltered' => $totalTodoItems,
        ];
    }
}
