<?php

namespace App\Http\Controllers\Traits;

use App\Enums\OrderType;
use Illuminate\Http\Request;

/**
 * Trait HandlesDataTableRequest
 * @package App\Data\Traits\Feature
 */
trait HandlesDataTableRequest
{
    /**
     * Retrieves request data.
     *
     * @param Request $request
     * @return array
     */
    public function getRequestData(Request $request): array
    {
        $search = $request->get('search')['value'] ?? null;
        $offset = $request->get('start', 0);
        $length = $request->get('length');
        $orderData = $request->get('order', []);

        if (! empty($orderData)) {
            $orderColumn = self::COLUMN_MAPPINGS[$orderData[0]['column']];
            $orderDirection = $orderData[0]['dir'];
        } else {
            $orderColumn = self::COLUMN_MAPPINGS[0];
            $orderDirection = OrderType::DESC;
        }

        return [
            $search,
            $offset,
            $length,
            $orderColumn,
            $orderDirection
        ];
    }
}
