<?php

namespace App\Repositories;

use App\Enums\OrderType;
use App\Models\TodoItem;
use Illuminate\Support\Collection;

/**
 * Class TodoItemRepository
 * @package App\Data\Repositories
 */
class TodoItemRepository extends BaseRepository
{
    /**
     * TodoItemRepository constructor.
     * @param TodoItem $item
     */
    public function __construct(TodoItem $item)
    {
        parent::__construct($item);
    }


    /**
     * Retrieve filtered users.
     *
     * @param string|null $searchQuery
     * @param int $skip
     * @param int $length
     * @param string $orderBy
     * @param string $orderType
     * @return Collection
     */
    public function filter(
        ?string $searchQuery,
        int $skip,
        int $length,
        string $orderBy,
        string $orderType = OrderType::DESC
    ): Collection {
        $searchStatement = "%{$searchQuery}%";
        $query = $this->model;

        if ($searchQuery !== null && !empty($searchQuery)) {
            $query = $query
                ->where('title', 'LIKE', $searchStatement)
                ->orWhere('description', 'LIKE', $searchStatement);
        }

        return $query
            ->skip($skip)
            ->take($length)
            ->orderBy($orderBy, $orderType)
            ->get();
    }
}
