<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/**
 * Class TodoItemTableResource
 * @package App\Http\Resources
 */
class TodoItemTableResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param Request $request
     * @return array
     */
    public function toArray($request): array
    {
        return [
            $this->id,
            $this->title,
            $this->shortDescription,
            $this->created_at->format('Y-m-d H:i:s'),
            [
                view('layouts.partials.action-buttons', ['item' => $this->resource])->render()
            ]
        ];
    }
}
