<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

/**
 * App\Models\TodoItem
 *
 * @method static \Illuminate\Database\Eloquent\Builder|TodoItem newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|TodoItem newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|TodoItem query()
 * @mixin \Eloquent
 * @property int $id
 * @property string $title
 * @property string $description
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|TodoItem whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TodoItem whereDescription($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TodoItem whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TodoItem whereTitle($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TodoItem whereUpdatedAt($value)
 * @property-read string $short_description
 * @method static \Database\Factories\TodoItemFactory factory(...$parameters)
 */
class TodoItem extends Model
{
    use HasFactory;

    /**
     * The attributes that aren't mass assignable.
     *
     * @var string[]
     */
    protected $guarded = ['id'];

    /**
     * The accessors to append to the model's array form.
     *
     * @var string[]
     */
    protected $appends = ['shortDescription'];

    /**
     * Getter for short description attribute
     *
     * @return string
     */
    public function getShortDescriptionAttribute(): string
    {
        return Str::words($this->description, 3,' ...');
    }
}
