/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!********************************!*\
  !*** ./resources/js/custom.js ***!
  \********************************/
$(document).ready(function () {
  var currentItem = {};
  var csrfToken = document.head.querySelector("[name~=csrf-token][content]").content;
  var $dataTable = $('#todoItems-table'); // init dataTable

  $dataTable.DataTable({
    processing: true,
    serverSide: true,
    ajax: {
      url: '/todo/table',
      type: 'GET'
    },
    "order": [[0, 'desc'], [1, 'desc'], [2, 'desc']],
    paggingType: "full_numbers",
    lengthMenu: [[5, 10, 100], [5, 10, 100]]
  }); // open modal window confirm destroing

  $('body').on('click', '.destroy-todo', function (e) {
    e.preventDefault();
    currentItem = JSON.parse($(this).closest('.btns-row').attr('data-item'));
    $('#modal-window').css('display', 'block');
    $('#cancel').on('click', function () {
      $('#modal-window').css('display', 'none');
    });
  }); // confirm deleting todoItem

  $('#confirm').on('click', function () {
    fetch("/todo-items/".concat(currentItem.id), {
      method: 'DELETE',
      cache: "no-cache",
      credentials: "same-origin",
      headers: {
        'Accept': "application/json",
        'Content-Type': 'application/json',
        "X-CSRF-Token": csrfToken
      }
    }).then(function (response) {
      if (response.status === 422) {
        return response.json();
      }

      return response.status;
    }).then(function (responseErrors) {
      if (!(responseErrors !== null && responseErrors !== void 0 && responseErrors.errors)) {
        reload();
        $('#modal-window').css('display', 'none');
      }
    });
  }); //open modal window to show edit modal page

  $('body').on('click', '.edit-todo', function (e) {
    e.preventDefault();
    currentItem = JSON.parse($(this).closest('.btns-row').attr('data-item'));
    $('#modal-window-edit').css('display', 'block');
    $('#title').val(currentItem.title);
    $('#description').val(currentItem.description);
  }); //confirmation of updating todoItem

  $('#update-todo').on('click', function (e) {
    e.preventDefault();
    fetch("/todo-items/".concat(currentItem.id), {
      method: 'PUT',
      cache: "no-cache",
      credentials: "same-origin",
      headers: {
        'Accept': "application/json",
        'Content-Type': 'application/json',
        "X-CSRF-Token": csrfToken
      },
      body: JSON.stringify({
        "title": $('#title').val(),
        "description": $('#description').val()
      })
    }).then(function (response) {
      if (response.status === 422) {
        return response.json();
      }

      return response.status;
    }).then(function (responseErrors) {
      if (!(responseErrors !== null && responseErrors !== void 0 && responseErrors.errors)) {
        reload();
        $('#modal-window-edit').css('display', 'none');
      } else {
        showErrors(responseErrors);
      }
    });
  }); //reloading todoItem table list

  function reload() {
    $dataTable.DataTable().ajax.reload(null, false);
  } //show errors


  function showErrors(errorsForm) {
    if (errorsForm.length === 0) {
      return;
    }

    $('.errors').remove();
    $.each(errorsForm.errors, function (key, value) {
      $('.errors-container').append("<div class=\"errors\">".concat(value, "</div"));
    });
  } // hide modal window


  $('.close').on('click', function () {
    $('#modal-window , #modal-window-edit').css('display', 'none');
  });
});
/******/ })()
;