<?php

namespace App\Console\Commands;

use App\Http\Services\Socket\Socket;
use Illuminate\Console\Command;
use Ratchet\Http\HttpServer;
use Ratchet\Server\IoServer;
use Ratchet\WebSocket\WsServer;

class StartSocket extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'socket:start';

    /**
     * @var string
     */
    protected $port = '8888';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Start WebSocket server';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        // Show message in console.
        $this->info('WebSocket server started... Listen: localhost:' . $this->port);

        // Declare socket.
        $server = IoServer::factory(
            new HttpServer(
                new WsServer(
                    new Socket()
                )
            ), $this->port
        );

        // Start socket.
        $server->run();
    }
}
