<?php

namespace App\Http\Controllers;

use App\Http\Services\Users\Edit;
use App\Http\Services\Users\Index;
use App\Http\Services\Users\Store;
use App\Http\Services\Users\Update;
use App\Http\Services\Users\Destroy;
use Illuminate\Http\Request;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return response()->json($this->run(Index::class));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        return response()->json($this->run(Store::class, [
            'request' => $request
        ]));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $userId
     * @return \Illuminate\Http\Response
     */
    public function edit($userId)
    {
        return response()->json($this->run(Edit::class, [
            'userId' => $userId
        ]));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $userId
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $userId)
    {
        return response()->json($this->run(Update::class, [
            'request' => $request,
            'userId'  => $userId
        ]));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $userId
     * @return \Illuminate\Http\Response
     */
    public function destroy($userId)
    {
        return response()->json($this->run(Destroy::class, [
            'userId' => $userId
        ]));
    }
}
