<?php

namespace App\Http\Services\Users;

use App\Repositories\UserRepository;
use Illuminate\Support\Facades\Validator;

class Update
{
    /**
     * @var $userId
     */
    private $userId;

    /**
     * @var $request
     */
    private $request;

    /**
     * @var UserRepository
     */
    private $userRepository;

    /**
     * Update constructor.
     * @param array $args
     */
    public function __construct(array $args)
    {
        $this->userId  = $args['userId'];
        $this->request = $args['request'];
        $this->userRepository = new UserRepository();
    }

    /**
     * @return array
     */
    public function handle()
    {
        // Validate request.
        $validator = $this->validate($this->request->all());

        // Save new user.
        if (!$validator->fails()) {
            return ['status' => $this->userRepository->update($this->request, $this->userId)];
        }

        return ['status' => false, 'errors' => $validator->messages()];
    }

    /**
     * @param array $request
     * @return mixed
     */
    private function validate(array $request)
    {
        return Validator::make($request, [
            'name'     => 'required|string|max:255',
            'email'    => 'required|string|email|max:255|unique:users,email,'.$this->userId,
            'password' => 'required|string|min:6',
        ]);
    }
}