import Vue    from "vue"
import config from "./../config/index"

/** Send new message */
const emitter = new Vue({
    data: {
        socket: null
    },
    created() {
        /** Start socket. */
        this.start();

        /** On message event. */
        this.onMessage();

        /** On error event. */
        this.onError();
    },
    methods: {
        send(message){
            if (this.socket.readyState === 1) {
                this.socket.send(message)
            }
        },
        start(){
            this.socket = new WebSocket(config.wsHost);
        },
        onMessage(){
            this.socket.onmessage = function(msg){
                emitter.$emit("message", msg.data)
            };
        },
        onError(){
            this.socket.onerror = function(err){
                emitter.$emit("error", err)
            };
        },
    }
});

export default emitter