import Vue    from 'vue'
import VueX   from 'vuex'
import router from './../router'
import config from './../config/index'

Vue.use(VueX);

export default new VueX.Store({
    state: {
        host: config.host,
        counter: 0,
        token: null,
    },
    getters: {
        isAuth(state) {
            return !!state.token || !!localStorage.getItem('user-token');
        },
        unAuth(state, getters) {
            state.token = null;
            localStorage.removeItem('user-token');

            if(!getters.isAuth) {
                return router.push(config.redirectIfLogout)
            }
        }
    },
    mutations: {
        toAuth: (state, token) => {
            state.token = token;
            localStorage.setItem('user-token', token);

            return router.push(config.redirectIfAuth)
        }
    },
});