<?php

namespace App\Http\Controllers\Auth;

use App\Http\Services\Users\Store;
use App\Repositories\UserRepository;
use App\User;
use Illuminate\Http\Request;
use Tymon\JWTAuth\Facades\JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;
use App\Http\Controllers\Controller;
use App\Http\Requests\RegisterAuthRequest;

class ApiAuthController extends Controller
{
    /**
     * @var bool
     */
    public $loginAfterSignUp = true;

    /**
     * @param RegisterAuthRequest $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function register(Request $request)
    {
        // Declare user store.
        $storeUser = new Store([
            'request' => $request
        ]);

        // Save user.
        $createUser = $storeUser->handle();

        // Login user.
        if($this->loginAfterSignUp && $createUser['status']) {
            return $this->login($request);
        }

        return response()->json($createUser, 200);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function login(Request $request)
    {
        // Get request params.
        $input = $request->only('email', 'password');
        $jwt_token = null;

        // Auth user.
        if (!$jwt_token = JWTAuth::attempt($input)) {
            return response()->json([
                'success' => false,
                'message' => 'Invalid Email or Password',
            ], 200);
        }

        return response()->json([
            'success' => true,
            'token'   => $jwt_token,
        ]);
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function logout(Request $request)
    {
        // Validate request.
        $this->validate($request, [
            'token' => 'required'
        ]);

        // Logout user by token.
        try {
            JWTAuth::parseToken()->invalidate();
//            JWTAuth::invalidate($request->token);

            return response()->json([
                'success' => true,
                'message' => 'User logged out successfully'
            ]);
        } catch (JWTException $exception) {
            return response()->json([
                'success' => false,
                'message' => 'Sorry, the user cannot be logged out'
            ], 500);
        }
    }

    /**
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getAuthUser(Request $request)
    {
        // Validate request.
        $this->validate($request, [
            'token' => 'required'
        ]);

        // Get user by token.
        $user = JWTAuth::authenticate($request->token);

        return response()->json(['user' => $user]);
    }
}
