<?php

namespace App\Http\Services\Users;

use App\Repositories\UserRepository;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class Store
{
    /**
     * @var Request
     */
    private $request;

    /**
     * @var UserRepository
     */
    private $userRepository;

    /**
     * Store constructor.
     * @param array $args
     */
    public function __construct(array $args)
    {
        $this->request = $args['request'];
        $this->userRepository = new UserRepository();
    }

    /**
     * @return array
     */
    public function handle()
    {
        // Validate request.
        $validator = $this->validate($this->request->all());

        // Save new user.
        if (!$validator->fails()) {
            return ['status' => $this->userRepository->create($this->request)];
        }

        return ['status' => false, 'errors' => $validator->messages()];
    }

    /**
     * @param array $request
     * @return mixed
     */
    private function validate(array $request)
    {
        return Validator::make($request, [
            'name'     => 'required|string|max:255',
            'email'    => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:6',
        ]);
    }
}