<?php

namespace App\Repositories;

use App\User;

class UserRepository
{
    /**
     * @return string
     */
    public function model()
    {
        return new User;
    }

    /**
     * @param $request
     * @return mixed
     */
    public function create($request)
    {
        return $this
            ->model()
            ->create(
                [
                    'name'     => $request->name,
                    'email'    => $request->email,
                    'password' => bcrypt($request->password),
                ]);
    }

    /**
     * @return mixed
     */
    public function getAll()
    {
        return $this
            ->model()
            ->all();
    }

    /**
     * @param $userId
     * @return mixed
     */
    public function deleteById($userId)
    {
        return $this
            ->model()
            ->find($userId)
            ->delete();
    }

    /**
     * @param $userId
     * @return mixed
     */
    public function getOneById($userId)
    {
        return $this
            ->model()
            ->whereId($userId)
            ->first();
    }

    /**
     * @param $request
     * @param $userId
     * @return mixed
     */
    public function update($request, $userId)
    {
        return $this
            ->model()
            ->whereId($userId)
            ->update(
                [
                    'name'     => $request->name,
                    'email'    => $request->email,
                    'password' => bcrypt($request->password),
                ]);
    }
}