import Vue       from 'vue';
import VueRouter from 'vue-router';
import store     from './../store'
import Home       from './../pages/Home';
import Chat       from './../pages/chat/Chat';
import Counter    from './../pages/Counter';
import Login      from "../pages/auth/Login";
import Register   from "../pages/auth/Register";
import Logout     from "../pages/auth/Logout";
import AdminHome  from "../pages/admin/Home";
import UsersIndex from './../pages/users/UsersIndex';
import UserCreate from './../pages/users/UserCreate';
import UserEdit   from './../pages/users/UserEdit';
import Validate   from './../pages/validate/Validate';
import Game       from './../pages/game/Game';

Vue.use(VueRouter);

// Is auth or not.
const isAuth = (to, from, next) => {
    if (store.getters.isAuth) {
        next();
        return
    }
    next('/login')
};

// Routes.
export default new VueRouter({
    routes: [
        /** Home. */
        {
            path: '',
            component: Home,
            name: 'home',
        },

        /** Counter. */
        {
            path: '/counter',
            component: Counter,
            name: 'counter',
        },

        /** Users. */
        {
            path: '/users',
            component: UsersIndex,
            name: 'users',
        },
        {
            path: '/users/create',
            component: UserCreate,
            name: 'users-create',
        },
        {
            path: '/users/:id/edit',
            component: UserEdit,
            name: 'users-edit',
        },

        /** Chat. */
        {
            path: '/chat',
            component: Chat,
            name: 'chat',
        },

        /** Validate. */
        {
            path: '/validate',
            component: Validate,
            name: 'validate',
        },

        /** Game. */
        {
            path: '/game',
            component: Game,
            name: 'game',
        },

        /** Auth. */
        {
            path: '/login',
            component: Login,
            name: 'login',
            beforeEnter: !isAuth,
        },
        {
            path: '/register',
            component: Register,
            name: 'register',
            beforeEnter: !isAuth,
        },
        {
            path: '/logout',
            component: Logout,
            name: 'logout',
            beforeEnter: isAuth,
        },

        /** Admin. */
        {
            path: '/admin/home',
            component: AdminHome,
            name: 'admin-home',
            beforeEnter: isAuth,
        },
    ],
    mode: 'history'
})
