<?php

namespace App\Http\Services\Users;

use App\Repositories\UserRepository;

class Destroy
{
    /**
     * @var userId
     */
    private $userId;

    /**
     * @var UserRepository
     */
    private $userRepository;

    /**
     * Destroy constructor.
     * @param int $userId
     */
    public function __construct(array $args)
    {
        $this->userId = $args['userId'];
        $this->userRepository = new UserRepository();
    }

    /**
     * @return array
     */
    public function handle()
    {
        return ['status' => $this->userRepository->deleteById($this->userId)];
    }
}