<?php

namespace App\Http\Services\Users;

use App\Repositories\UserRepository;
use Illuminate\Support\Facades\Log;

class Edit
{
    /**
     * @var userId
     */
    private $userId;

    /**
     * @var UserRepository
     */
    private $userRepository;

    /**
     * Edit constructor.
     * @param array $args
     */
    public function __construct(array $args)
    {
        $this->userId = $args['userId'];
        $this->userRepository = new UserRepository();
    }

    /**
     * @return array
     */
    public function handle()
    {
        return $this->userRepository->getOneById($this->userId);
    }
}