import Vue     from 'vue'

/** Start socket. */
const socket = new WebSocket('ws://localhost:8888');

/** Send new message */
const emitter = new Vue({
    methods:{
        send(message){
            if (1 === socket.readyState)
            socket.send(message)
        }
    }
});

/** On message event. */
socket.onmessage = function(msg){
    emitter.$emit("message", msg.data)
};

/** On error event. */
socket.onerror = function(err){
    emitter.$emit("error", err)
};

export default emitter