import Vue  from 'vue'
import VueX from 'vuex'
import router from './../router'

Vue.use(VueX);

export default new VueX.Store({
    state: {
        host: 'http://localhost:8000',
        // wsHost: 'ws://localhost:8888',
        counter: 0,
        token: null,
    },
    getters: {
        isAuth(state) {
            return !!state.token || !!localStorage.getItem('user-token');
        },
        unAuth(state, getters) {
            state.token = null;
            localStorage.removeItem('user-token');

            if(!getters.isAuth) {
                return router.push('/')
            }
        }
    },
    mutations: {
        toAuth: (state, token) => {
            state.token = token;
            localStorage.setItem('user-token', token);

            return router.push('/admin/home')
        }
    },
});