<?php

namespace App\Models\Regions;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use KoenHoeijmakers\LaravelTranslatable\HasTranslations;

/**
 * Class District
 * @package App\Models\Regions
 *
 * @property int $id
 * @property string $name
 * @property string $alias
 *
 * @property \App\Models\Regions\Region $region
 */
class District extends Model
{
    use HasTranslations;

    /**
     * {@inheritdoc}
     */
    protected $translatable = ['name'];

    /**
     * {@inheritdoc}
     */
    protected $fillable = ['name', 'region_id', 'alias'];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function region(): BelongsTo
    {
        return $this->belongsTo(Region::class);
    }

}
