<?php

namespace App\Providers;

use App\Contracts\GeolocationContract;
use App\Services\Geolocation\GeolocationService;
use Illuminate\Support\ServiceProvider;
use App\Contracts\RegionParserContract;
use App\Services\Regions\RegionParseService;

/**
 * Class ParseServiceProvider
 * @package App\Providers
 */
class ParseServiceProvider extends ServiceProvider
{
    /**
     * {@inheritdoc}
     */
    public function register(): void
    {
        $this->app->bind(RegionParserContract::class, RegionParseService::class);
        $this->app->bind(GeolocationContract::class, GeolocationService::class);
    }
}
