<?php


namespace App\Repositories;

use App\Contracts\CityContract;
use App\Models\Regions\City;
use Illuminate\Database\Eloquent\Collection;

/**
 * Class CityRepository
 * @package App\Repositories
 *
 * @property City $model
 */
class CityRepository extends Repository implements CityContract
{
    /**
     * {@inheritdoc}
     */
    protected function getModelClass(): string
    {
        return City::class;
    }

    /**
     * @param int $id
     * @param \Illuminate\Support\Collection $attributes
     * @return bool
     */
    public function updateContacts(int $id, $attributes): bool
    {
        if (!$model = $this->find($id)) {
            return false;
        }

        if ($image = $attributes->get('image')) {
            $attributes->forget('image');
            $model->updateEmblem($image);
        }

        $model->fill($attributes->toArray())->save();

        return true;
    }

    /**
     * @param string $field
     * @param string $value
     * @param string $comparison
     * @return Collection
     */
    public function searchBy(string $field, string $value, string $comparison = '='): Collection
    {
        return $this->model->where($field, $comparison, $value)->get();
    }

    /**
     * @param string $field
     * @param string $value
     * @return City|null
     */
    public function getBy(string $field, string $value): ?City
    {
        return $this->model->where($field, $value)->first();
    }
}
