<?php

namespace App\Services\Geolocation;

use App\Contracts\CityContract;
use App\Contracts\GeolocationContract;

/**
 * Class GeolocationService
 * @package App\Services\Geolocation
 */
class GeolocationService implements GeolocationContract
{
    /**
     * @var \App\Contracts\CityContract
     */
    protected $cities;

    /**
     * GeolocationService constructor.
     *
     * @param \App\Contracts\CityContract $cities
     */
    public function __construct(CityContract $cities)
    {
        $this->cities = $cities;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function getCities()
    {
        return $this->cities->all();
    }

    /**
     * {@inheritdoc}
     *
     * @param \App\Models\Regions\City $city
     */
    public function locateCity($city): void
    {
        if ($data = collect(\Geocoder::getCoordinatesForAddress($city->address))) {
            $this->cities->updateOrStore(['cities.id' => $city->id], [
                'coordinates' => ['lat' => $data->get('lat'), 'lng' => $data->get('lng')]
            ]);
        }
    }
}
