<?php


namespace App\Console\Commands;

use App\Services\Regions\Jobs\ParseRegionDistricts;
use Illuminate\Console\Command;

/**
 * Class ImportRegionsData
 * @package App\Commands
 */
class ImportRegionsData extends Command
{
    /**
     * {@inheritdoc}
     */
    protected $signature = 'data:import';

    /**
     * {@inheritdoc}
     */
    protected $name = 'Import data into database';

    /**
     * @var \App\Contracts\RegionParserContract
     */
    protected $service;

    /**
     * ImportRegionsData constructor.
     *
     * @param \App\Contracts\RegionParserContract $service
     */
    public function __construct(\App\Contracts\RegionParserContract $service)
    {
        parent::__construct();
        $this->service = $service;
    }

    /**
     * Import all cities into database.
     *
     * @return void
     */
    public function handle(): void
    {
        $this->service->getRegions()->each(function ($item) {
            $this->output->writeln(__('parse.region.start', ['name' => $item->name]));
            dispatch(new ParseRegionDistricts($this->service, $item));
            $this->output->writeln(__('parse.region.queued', ['name' => $item->name]));
        });
    }
}
