<?php


namespace App\Services\Geolocation\Jobs;


use App\Contracts\GeolocationContract;
use Illuminate\Bus\Queueable;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class GeolocateCity
{
    use Dispatchable, InteractsWithQueue, SerializesModels, Queueable;

    /**
     * @var \App\Contracts\GeolocationContract
     */
    protected $service;

    /**
     * @var \App\Models\Regions\City $city
     */
    protected $city;

    /**
     * @var bool
     */
    protected $force = false;

    /**
     * GeolocateCity constructor.
     *
     * @param \App\Contracts\GeolocationContract $service
     * @param $city
     * @param bool $force
     */
    public function __construct(GeolocationContract $service, $city, $force = false)
    {
        $this->service = $service;
        $this->city = $city;
        $this->force = $force;
    }

    /**
     * Handle city geolocation.
     */
    public function handle(): void
    {
        if ($this->force || !$this->city->location) {
            $this->service->locateCity($this->city);
        }
    }
}
